---
title: Use the latest JavaScript features with Wrangler CLI v4 · Changelog
description: Wrangler v4 is available!
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-13-wrangler-v4/
  md: https://developers.cloudflare.com/changelog/2025-03-13-wrangler-v4/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Use the latest JavaScript features with Wrangler CLI v4

Mar 13, 2025

[Workers](https://developers.cloudflare.com/workers/)

We've released the next major version of [Wrangler](https://developers.cloudflare.com/workers/wrangler/), the CLI for Cloudflare Workers — `wrangler@4.0.0`. Wrangler v4 is a major release focused on updates to underlying systems and dependencies, along with improvements to keep Wrangler commands consistent and clear.

You can run the following command to install it in your projects:

* npm

  ```sh
  npm i wrangler@latest
  ```

* yarn

  ```sh
  yarn add wrangler@latest
  ```

* pnpm

  ```sh
  pnpm add wrangler@latest
  ```

Unlike previous major versions of Wrangler, which were [foundational rewrites](https://blog.cloudflare.com/wrangler-v2-beta/) and [rearchitectures](https://blog.cloudflare.com/wrangler3/) — Version 4 of Wrangler includes a much smaller set of changes. If you use Wrangler today, your workflow is very unlikely to change.

A [detailed migration guide](https://developers.cloudflare.com/workers/wrangler/migration/update-v3-to-v4) is available and if you find a bug or hit a roadblock when upgrading to Wrangler v4, [open an issue on the `cloudflare/workers-sdk` repository on GitHub](https://github.com/cloudflare/workers-sdk/issues/new?template=bug-template.yaml).

Going forward, we'll continue supporting Wrangler v3 with bug fixes and security updates until Q1 2026, and with critical security updates until Q1 2027, at which point it will be out of support.
