---
title: Automated reminders for backup codes · Changelog
description: Cloudflare reminds you to download your 2FA recovery keys
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-10-07-recovery-codes/
  md: https://developers.cloudflare.com/changelog/2025-10-07-recovery-codes/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Automated reminders for backup codes

Oct 07, 2025

[Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

The most common reason users contact Cloudflare support is lost two-factor authentication (2FA) credentials. Cloudflare supports both app-based and hardware keys for 2FA, but you could lose access to your account if you lose these. Over the past few weeks, we have been rolling out email and in-product reminders that remind you to also download backup codes (sometimes called recovery keys) that can get you back into your account in the event you lose your 2FA credentials. Download your backup codes now by logging into Cloudflare, then navigating to **Profile** > **Security & Authentication** > **Backup codes**.

#### Sign-in security best practices

Cloudflare is critical infrastructure, and you should protect it as such. Please review the following best practices and make sure you are doing your part to secure your account.

* Use a unique password for every website, including Cloudflare, and store it in a password manager like 1Password or Keeper. These services are cross-platform and simplify the process of managing secure passwords.

* Use 2FA to make it harder for an attacker to get into your account in the event your password is leaked

* Store your backup codes securely. A password manager is the best place since it keeps the backup codes encrypted, but you can also print them and put them somewhere safe in your home.

* If you use an app to manage your 2FA keys, enable cloud backup, so that you don't lose your keys in the event you lose your phone.

* If you use a custom email domain to sign in, [configure SSO](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/).

* If you use a public email domain like Gmail or Hotmail, you can also use social login with Apple, GitHub, or Google to sign in.

* If you manage a Cloudflare account for work:

  * Have at least two administrators in case one of them unexpectedly leaves your company
  * Use SCIM to automate permissions management for members in your Cloudflare account
