---
title: Tenant custom nameservers · Cloudflare DNS docs
description: With tenant-level custom nameservers, you can use the same custom
  nameservers for different zones and across different accounts, as long as the
  accounts are part of the [tenant](/tenant/). The domain or domains that
  provide the nameservers names do not have to exist as zones in Cloudflare.
lastUpdated: 2025-11-11T08:44:08.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/nameservers/custom-nameservers/tenant-custom-nameservers/
  md: https://developers.cloudflare.com/dns/nameservers/custom-nameservers/tenant-custom-nameservers/index.md
---

Tenant custom nameservers (TCNS) allow you to define tenant-level custom nameservers and use them for different accounts within a Cloudflare tenant.

TCNS are organized in different sets (`ns_set`) and TCNS names can be provided by any domain, even if the domain does not exist as a zone in Cloudflare.

For instance, if the TCNS are `ns1.example.com` and `ns2.vanity.test`, the domains `example.com` and `vanity.test` are not required to be zones in Cloudflare.

## Availability

Tenant custom nameservers, if created by the tenant owner, will be available to all zones belonging to any account that is part of the tenant. Via API only.

## Configuration conditions

For this configuration to be possible, a few conditions apply:

* Tenant owners can create up to five different tenant custom nameserver sets. Each nameserver set must have between two and five different nameserver names (`ns_name`), and each name cannot belong to more than one set. For example, if `ns1.example.com` is part of `ns_set 1` it cannot be part of `ns_set 2` or vice versa.
* [Subdomain setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/) or [reverse zones](https://developers.cloudflare.com/dns/additional-options/reverse-zones/) can use tenant custom nameservers as long as they use a different nameserver set (`ns_set`) than their parent, child, or any other zone in their direct hierarchy tree.

Note

Tenant owners that want to [use their own IP prefix](https://developers.cloudflare.com/byoip/) for the tenant custom nameservers should contact their account team.

## For account owners

### Enable tenant custom nameservers on a zone

If you are an account owner and your account is part of a tenant that has custom nameservers, do the following:

1. Use a [PUT command](https://developers.cloudflare.com/api/resources/zones/subresources/custom_nameservers/methods/update/) and specify `ns_type` and `ns_set`.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zone Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_ns" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "enabled": true,
    "ns_type": "tenant",
    "ns_set": "<SET>"
  }'
```

Note

If the parameter `ns_type` is omitted, the default type `account` will be assigned.

If the parameter `ns_set` is omitted, the default set `1` will be assigned.

1. If you are **not** using [Cloudflare Registrar](https://developers.cloudflare.com/registrar/), update the nameservers at your registrar to use the TCNS names. If you are using [Cloudflare Registrar](https://developers.cloudflare.com/registrar/), no further action is needed.

To make these TCNS the default namerservers for all new zones added to your account from now on, use the endpoint [Update DNS Settings for an Account](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/account/methods/edit/). Within the `zone_defaults` object, set the following:

```txt
"zone_defaults": {
  "nameservers": {
    "type": "custom.tenant"
  }
}
```

### Disable tenant custom nameservers on a zone

To remove TCNS and their associated DNS records from a zone, use a [PUT command](https://developers.cloudflare.com/api/resources/zones/subresources/custom_nameservers/methods/update/).

If you are **not** using [Cloudflare Registrar](https://developers.cloudflare.com/registrar/), also remove the TCNS at your domain’s registrar.

## For tenant owners

### Create tenant custom nameservers

If you are a tenant owner and you want to make TCNS available for accounts within your tenant, do the following:

1. Observe the [conditions](#configuration-conditions) for `ns_name` and `ns_set`, and create TCNS in your tenant by using the following POST command:

```bash
curl https://api.cloudflare.com/client/v4/tenants/{tenant_id}/custom_ns \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>" \
--header "Content-Type: application/json" \
--data '{
  "ns_name": "<NS_NAME>",
  "ns_set": <SET>
}'
```

Note

If the parameter `ns_set` is omitted, the default set `1` will be assigned.

1. Add the account custom nameservers and IP addresses to your domain's registrar as glue (A and AAAA) records ([RFC 1912](https://www.rfc-editor.org/rfc/rfc1912.html)).

2. If the domain or domains that are used for the tenant custom nameservers do not exist within the same account, you must create the `A/AAAA` records on the configured nameserver names (for example, `ns1.example.com`) at the authoritative DNS provider.

| Type | Name | Content |
| - | - | - |
| `A` | `ns1.example.com` | `<IPv4>` |

### Get a list of all TCNS names

To get a list of all TCNS names in your tenant account, use the following API request:

```bash
curl https://api.cloudflare.com/client/v4/tenants/{tenant_id}/custom_ns \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>"
```
