---
title: Single Redirects · Cloudflare Rules docs
description: Single Redirects allow you to create static or dynamic URL
  redirects. A simple interface with wildcard support makes it easy to define
  source and target URL patterns without needing complex functions or regular
  expressions, efficiently handling thousands of URLs with a single rule.
  Dynamic URL redirects also support advanced features such as string
  replacement operations and regular expressions (depending on your Cloudflare
  plan).
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/single-redirects/
  md: https://developers.cloudflare.com/rules/url-forwarding/single-redirects/index.md
---

Single Redirects allow you to create static or dynamic URL redirects. A simple interface with [wildcard support](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/#wildcard-matching) makes it easy to define source and target URL patterns without needing complex functions or regular expressions, efficiently handling thousands of URLs with a single rule. Dynamic URL redirects also support advanced features such as string replacement operations and [regular expressions](https://developers.cloudflare.com/ruleset-engine/rules-language/values/#string-values-and-regular-expressions) (depending on your Cloudflare plan).

For more complex and customized redirect logic, consider using [Snippets](https://developers.cloudflare.com/rules/snippets/).

***

## Related resources

* [Availability](https://developers.cloudflare.com/rules/url-forwarding/#availability): Information on the Single Redirects quotas and features per Cloudflare plan.
* [Execution order](https://developers.cloudflare.com/rules/url-forwarding/#execution-order): Execution order of the different Rules products.
* [Trace a request](https://developers.cloudflare.com/rules/trace-request/): Use Cloudflare Trace to determine if a redirect rule is triggering for a specific URL.
