---
title: Troubleshoot protocol issues · Cloudflare Speed docs
description: This guide covers common HTTP/2 and HTTP/3 issues, including origin
  incompatibility, multiplexing errors, and browser errors, with steps to
  diagnose and resolve them.
lastUpdated: 2025-03-14T11:28:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/optimization/protocol/troubleshooting/protocol-troubleshooting/
  md: https://developers.cloudflare.com/speed/optimization/protocol/troubleshooting/protocol-troubleshooting/index.md
---

This guide covers common HTTP/2 and HTTP/3 issues, including origin incompatibility, multiplexing errors, and browser errors, with steps to diagnose and resolve them.

## H2 to Origin - Origin incompatibility

* The origin's `max_concurrent_streams` is negotiated during the handshake process.
* If a `GOAWAY(0)` is received, it is likely due to a server restart or another reason causing the server to refuse new streams.
* For more information, refer to [RFC 9113 - SETTINGS\_MAX\_CONCURRENT\_STREAMS](https://datatracker.ietf.org/doc/html/rfc9113).

## H2 Multiplexing - Origin incompatibility/issues

* Multiplexing issues can arise due to incorrect server configurations.
* Use [netlogs](https://www.chromium.org/developers/design-documents/network-stack/netlog/) to identify `SETTINGS_MAX_CONCURRENT_STREAMS` violations or unexpected `GOAWAY` frames.
* For more information, refer to [Stream Concurrency Issues](https://datatracker.ietf.org/doc/html/rfc9113#name-stream-concurrency).

## Generic browser errors

Common browser errors include:

* `ERR_HTTP2_PROTOCOL_ERROR`
* `ERR_HTTP3_PROTOCOL_ERROR`
* `ERR_QUIC_PROTOCOL_ERROR`

These errors do not necessarily indicate a protocol-level issue. Follow these steps:

1. Attempt reproduction using HTTP/1.1.
2. If the issue persists in HTTP/1.1, address the underlying error before testing HTTP/2 or HTTP/3.
3. If the issue does not persist, analyze netlogs for HTTP/2 or HTTP/3-specific issues.

For more information, refer to [Chromium URL Request Header](https://chromium.googlesource.com/chromium/src/+/HEAD/net/url_request/url_request.h).
