---
title: Templates · Cloudflare Workers docs
description: GitHub repositories that are designed to be a starting point for
  building a new Cloudflare Workers project.
lastUpdated: 2025-11-03T19:32:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/get-started/quickstarts/
  md: https://developers.cloudflare.com/workers/get-started/quickstarts/index.md
---

Templates are GitHub repositories that are designed to be a starting point for building a new Cloudflare Workers project. To start any of the projects below, run:

### astro-blog-starter-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/astro-blog-starter-template)

Build a personal website, blog, or portfolio with Astro.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/astro-blog-starter-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/astro-blog-starter-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/astro-blog-starter-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/astro-blog-starter-template
  ```



***



### chanfana-openapi-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/chanfana-openapi-template)

Complete backend API template using Hono + Chanfana + D1 + Vitest.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/chanfana-openapi-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/chanfana-openapi-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/chanfana-openapi-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/chanfana-openapi-template
  ```



***



### cli

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/cli)

A handy CLI for developing templates.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/cli)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/cli
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/cli
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/cli
  ```



***



### containers-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/containers-template)

Build a Container-enabled Worker

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/containers-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/containers-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/containers-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/containers-template
  ```



***



### d1-starter-sessions-api-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/d1-starter-sessions-api-template)

D1 starter template using the Sessions API for read replication.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/d1-starter-sessions-api-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/d1-starter-sessions-api-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/d1-starter-sessions-api-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/d1-starter-sessions-api-template
  ```



***



### d1-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/d1-template)

Cloudflare's native serverless SQL database.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/d1-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/d1-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/d1-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/d1-template
  ```



***



### durable-chat-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/durable-chat-template)

Chat with other users in real-time using Durable Objects and PartyKit.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/durable-chat-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/durable-chat-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/durable-chat-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/durable-chat-template
  ```



***



### hello-world-do-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/hello-world-do-template)

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/hello-world-do-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/hello-world-do-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/hello-world-do-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/hello-world-do-template
  ```



***



### llm-chat-app-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/llm-chat-app-template)

A simple chat application powered by Cloudflare Workers AI

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/llm-chat-app-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/llm-chat-app-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/llm-chat-app-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/llm-chat-app-template
  ```



***



### multiplayer-globe-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/multiplayer-globe-template)

Display website visitor locations in real-time using Durable Objects and PartyKit.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/multiplayer-globe-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/multiplayer-globe-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/multiplayer-globe-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/multiplayer-globe-template
  ```



***



### mysql-hyperdrive-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/mysql-hyperdrive-template)

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/mysql-hyperdrive-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/mysql-hyperdrive-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/mysql-hyperdrive-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/mysql-hyperdrive-template
  ```



***



### next-starter-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/next-starter-template)

Build a full-stack web application with Next.js.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/next-starter-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/next-starter-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/next-starter-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/next-starter-template
  ```



***



### nlweb-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/nlweb-template)

Build Nl Web components with Cloudflare Workers.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/nlweb-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/nlweb-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/nlweb-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/nlweb-template
  ```



***



### nodejs-http-server-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/nodejs-http-server-template)

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/nodejs-http-server-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/nodejs-http-server-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/nodejs-http-server-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/nodejs-http-server-template
  ```



***



### openauth-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/openauth-template)

Deploy an OpenAuth server on Cloudflare Workers.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/openauth-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/openauth-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/openauth-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/openauth-template
  ```



***



### postgres-hyperdrive-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/postgres-hyperdrive-template)

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/postgres-hyperdrive-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/postgres-hyperdrive-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/postgres-hyperdrive-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/postgres-hyperdrive-template
  ```



***



### r2-explorer-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/r2-explorer-template)

A Google Drive Interface for your Cloudflare R2 Buckets!

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/r2-explorer-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/r2-explorer-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/r2-explorer-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/r2-explorer-template
  ```



***



### react-postgres-fullstack-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/react-postgres-fullstack-template)

Deploy your own library of books using Postgres and Workers.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/react-postgres-fullstack-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/react-postgres-fullstack-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/react-postgres-fullstack-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/react-postgres-fullstack-template
  ```



***



### react-router-hono-fullstack-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/react-router-hono-fullstack-template)

A modern full-stack template powered by Cloudflare Workers, using Hono for backend APIs, React Router for frontend routing, and shadcn/ui for beautiful, accessible components styled with Tailwind CSS

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/react-router-hono-fullstack-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/react-router-hono-fullstack-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/react-router-hono-fullstack-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/react-router-hono-fullstack-template
  ```



***



### react-router-postgres-ssr-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/react-router-postgres-ssr-template)

Deploy your own library of books using Postgres and Workers.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/react-router-postgres-ssr-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/react-router-postgres-ssr-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/react-router-postgres-ssr-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/react-router-postgres-ssr-template
  ```



***



### react-router-starter-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/react-router-starter-template)

Build a full-stack web application with React Router 7.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/react-router-starter-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/react-router-starter-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/react-router-starter-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/react-router-starter-template
  ```



***



### remix-starter-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/remix-starter-template)

Build a full-stack web application with Remix.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/remix-starter-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/remix-starter-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/remix-starter-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/remix-starter-template
  ```



***



### saas-admin-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/saas-admin-template)

Admin dashboard template built with Astro, shadcn/ui, and Cloudflare's developer stack

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/saas-admin-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/saas-admin-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/saas-admin-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/saas-admin-template
  ```



***



### text-to-image-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/text-to-image-template)

Generate images based on text prompts.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/text-to-image-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/text-to-image-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/text-to-image-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/text-to-image-template
  ```



***



### to-do-list-kv-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/to-do-list-kv-template)

A simple to-do list app built with Cloudflare Workers Assets and Remix.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/to-do-list-kv-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/to-do-list-kv-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/to-do-list-kv-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/to-do-list-kv-template
  ```



***



### vite-react-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/vite-react-template)

A template for building a React application with Vite, Hono, and Cloudflare Workers

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/vite-react-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/vite-react-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/vite-react-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/vite-react-template
  ```



***



### worker-publisher-template

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/worker-publisher-template)

A Cloudflare Worker template that creates and deploys Workers to a Dispatch Namespace via the Cloudflare SDK.

Explore on [GitHub ↗](https://github.com/cloudflare/templates/tree/main/worker-publisher-template)

* npm

  ```sh
  npm create cloudflare@latest -- --template=cloudflare/templates/worker-publisher-template
  ```

* yarn

  ```sh
  yarn create cloudflare --template=cloudflare/templates/worker-publisher-template
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest --template=cloudflare/templates/worker-publisher-template
  ```



***

